﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class LivesCounterScript : MonoBehaviour {

	private Text uiText;

	public int maxLives;
	private int lives;
	
	void Start () {
		lives = maxLives;
		uiText = this.GetComponent<Text> ();
		updateLivesCounter();
	}

	//Zwraca true, jeśli życie zostało dodane
	public bool addLife(){
		if (lives < maxLives) {
			lives++;
			updateLivesCounter();
			return true;
		}
		return false;
	}

	//Zwraca true, jeśli gracz nie ma już żadnego życia
	public bool loseLife(){
		lives--;
		if (lives > 0) {
			updateLivesCounter();
			return false;
		}
		lives = 0;
		updateLivesCounter();
		return true;
	}

	private void updateLivesCounter(){
		uiText.text = "<color=red>Lives</color>: " + lives;
	}

	//Opcje dodatkowe
	public void increaseMaxLives(int value){
		maxLives += value;
	}

	//Opcje dodtakowe
	public void decreaseMaxLives(int value){
		maxLives -= value;
		if (maxLives < 1)
			maxLives = 1;
		if (lives > maxLives)
			lives = maxLives;
	}

	//Opcje dodatkowe
	public int getLives(){
		return lives;
	}
}
